package gov.va.med.mhv.adminPortal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;

import gov.va.med.mhv.adminPortal.util.DatabaseConnection;
import weblogic.ejbgen.Constants;
import weblogic.ejbgen.FileGeneration;
import weblogic.ejbgen.JndiName;
import weblogic.ejbgen.Session;

import com.bea.p13n.property.EntityPropertyManager;
import com.bea.p13n.property.PropertyLocator;
import com.bea.p13n.property.internal.EntityPropertyManagerImpl;


@Session(ejbName = "AdminPortalPropertyManager", type=Session.SessionType.STATELESS)
@JndiName(remote = "ejb.AdminPortalPropertyManagerJNDI")
@FileGeneration( remoteClass = Constants.Bool.FALSE, remoteHome = Constants.Bool.FALSE, localClass = Constants.Bool.FALSE, localHome = Constants.Bool.FALSE)
public class AdminPortalPropertyManager
		extends EntityPropertyManagerImpl implements EntityPropertyManager {
	private static final long serialVersionUID = 1L;

	private static final String userRoleQuery = "select distinct r.name from ROLE r "
							+ "inner join EMPLOYEE_ORG_ROLE eor on r.role_id = eor.role_id "
							+ "inner join EMPLOYEE e on eor.employee_id = e.employee_id "
							+ "where eor.active = 1 and e.user_name = ";

	public void ejbCreate() {}

	public Object getProperty(PropertyLocator locator, String propertySet, String propertyName)
	{

		if (propertyName.equals("roleNames"))
		{
			Collection<String> userRoles = new ArrayList<String>();
			Connection conn = null;
			Statement stmt = null;
			ResultSet rs = null;
			try {
				conn = DatabaseConnection.getConnection();
				stmt = conn.createStatement();
				String userName = (locator.getPkString() != null ? locator.getPkString().toLowerCase() : locator.getPkString());
				rs = stmt.executeQuery(userRoleQuery + "'" + userName + "'");
				while (rs.next()) {
					userRoles.add(rs.getObject(1).toString());
				}
				
				return userRoles;
			}
			catch (Exception e)	{ e.printStackTrace(); }
			finally {
				   	if (rs != null) {
				   		try { rs.close(); } catch (Exception e) { e.printStackTrace(); }
				   	}
				    if (stmt != null) {
				    	try { stmt.close(); } catch (Exception e) { e.printStackTrace(); }
					}	
				    if (conn != null) {
					    try { conn.close(); } catch (Exception e) { e.printStackTrace(); }			
				    }
			}
		}
		return propertyName + " Unsupported";
	}

	public long createUniqueId(String jndiHomeName, String pkString) { System.out.println("\n\n In createUniqueId()\n\n"); return -1; }
	public void removeEntity(PropertyLocator locator) throws UnsupportedOperationException { throw new UnsupportedOperationException(); }
	public void setProperty(PropertyLocator locator, String propertySet, String propertyName, Object value) throws UnsupportedOperationException { throw new UnsupportedOperationException(); }
	public void removeProperties(PropertyLocator arg) throws UnsupportedOperationException { throw new UnsupportedOperationException(); }
	public Object removeProperty(PropertyLocator locator, String propertySet, String propertyName) throws UnsupportedOperationException { throw new UnsupportedOperationException(); }
	public EJBHome getEJBHome() { return null; }
	public Handle getHandle() { return null; }
	public Object getPrimaryKey() { return null; }
	public boolean isIdentical(EJBObject arg0) { return false; }
	public void remove() throws RemoveException { }
}
